function [nVol, Q_tip, Q_lat, Q_drain, Q_mesh, Q_rlf, Q_back, Q_leak] = etaVol(theta, p_seal, p_trap, Displ, rho, index)
%UNTITLED2 Summary of this function goes here
%  Detailed explanation goes here
global pcav 
global Z
global w
global omega
global TC
global LC
global DR
global pa
global pD
global pm
global BM
global mu 
global BC
global rhocav
global GArea
global Gangle

%INPUT from .xlsx FILE 
filename = 'Gprofile.xlsx'; 
M = readmatrix(filename,'Sheet', 1, 'Range','A4:G4');
TW_t = M(3); MT = M(7);
M = readmatrix(filename,'Sheet', 2);
TR = M(:, 1); 

filename = 'GPgeometry.xlsx'; 
M =  readmatrix(filename,'Sheet', 1, 'Range', 'A2');
UDA = M(:, 4); NoSV = M(:, 6); thcontact1 = M(:, 7);
thseal1 = M(:, 11); thseal2 = M(:, 12);

UDA = UDA(1 : length(p_trap));

TH = TR(end) - TR(1);

bmesh = 0.5*(TR(end)+TR(1)) - TR(1);
lmesh = MT;
hmesh = LC;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DEFINITION OF LEAKAGES BASED ON GEOMETRY (TIP, SIDE, DRAINAGE, DELIVERY RELIEF)
Qtip = @(dp, ht) w*ht.^3/(12*mu*TW_t)*(dp) + .5*(w*ht*omega*TR(end));
                                                   %[mm3/s] !!!!!!!!!!!!!!
Qlat = @(dp)  TH*LC.^3/(12*mu*MT)*(dp) + .5*(TH*LC*omega*(.5*(TR(1)+TR(end))));
                                                   %[mm3/s] !!!!!!!!!!!!!!
Qdrain = @(p)  (.5*TR(1)*2*pi/Z)*LC.^3/(12*mu*(TR(1)-DR))*(p-pD);
                                                   %[mm3/s] !!!!!!!!!!!!!! 
Qrlf = @(Adel, p) (0.65*Adel.*(1e3*sqrt(2*abs(pm - p)./rho))).*(pm>=p) + ...
                   0.*(pm<p);
                                                   %[mm3/s] !!!!!!!!!!!!!!
Qgroove = @(p, A) 0.65*A.*(1e3*sqrt(2*abs(pm - p)./rho)).*(pm>=p) + ...
                   0.*(pm<p);
                                                   %[mm3/s] !!!!!!!!!!!!!!
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Q_tip = zeros(1, length(theta)); Q_lat = Q_tip; Q_drain = Q_tip;
Q_mesh = Q_tip; Q_rlf = Q_tip; Q_back = Q_tip; Q_leak = Q_tip;

for ii = 1 : length(theta)
  %LAST SEALED TOOTH LEAKAGES (TIP AND SIDE) (both wheels)
  if NoSV(ii) == max(NoSV)
      ht = tipGap(NoSV(ii), TC, BC,  thseal1(ii), thseal2(ii));
      htip(ii) = ht(end);
      Dp(ii) = pm - p_seal(end, ii);
      if Dp(ii) == 0 && ii<size(p_seal,2), Dp(ii) = pm - p_seal(end, ii+1); end
      Q_tip(ii) = 2*Qtip(Dp(ii), htip(ii));
      Q_lat(ii) = 2*2*Qlat(Dp(ii)); %(*2 because both sides)
      if Q_tip(ii) < 0, Q_tip(ii) = 0; end
      if Q_lat(ii) < 0, Q_lat(ii) = 0; end
  else    
      ht = tipGap(NoSV(ii), TC, BC,  thseal1(ii), thseal2(ii));
      htip(ii) = ht(end);
      Dp(ii) = pm - p_seal(end-1, ii);
      if Dp(ii) == 0 && ii<size(p_seal,2), Dp(ii) = pm - p_seal(end-1, ii+1); end
      Q_tip(ii) = 2*Qtip(Dp(ii), htip(ii));
      Q_lat(ii) = 2*2*Qlat(Dp(ii)); %(*2 because both sides)
      if Q_tip(ii) < 0, Q_tip(ii) = 0; end
      if Q_lat(ii) < 0, Q_lat(ii) = 0; end
  end

  %DRAINAGE LEAKAGES (SINGLE WHEEL)
  %how many delivery vanes are leaking to the drainage
  if thcontact1(ii) <= 90, drain_open = thseal1(ii) - thcontact1(ii);
  elseif thcontact1(ii) >= 270, drain_open = thseal1(ii) + (360 - thcontact1(ii));
  end
  Q_drain(ii) = 2*2*ceil(drain_open/(360/Z))*Qdrain(pm); %(*2 because both sides)

  %MESHING ZONE LEAKAGE
  Q_mesh(ii) = 2*2*bmesh*hmesh.^3/(12*mu*lmesh)*(pm-pa); %[mm3/s] !!!!!

  %DELIVERY RELIEF GROOVE LEAKAGE
  if ii <= length(p_trap)
      Q_rlf(ii) = 2*Qrlf(UDA(ii), p_trap(ii)); %(*2 because both sides)
  else, Q_rlf(ii) = 0;
  end

  %BACKEND GROOVE LEAKAGE
  Agr = groove_leak_area(NoSV(ii), thseal1(ii), thseal2(ii), GArea, Gangle(1), Gangle(2))
  for kk = 1:length(Agr)
  Q_back_vec(kk) = Qgroove(p_seal(kk, ii), Agr(kk));
  end
  Q_back(ii) = 2*2*sum(Q_back_vec); %(*2 because both plates, 2* because both wheels)

  %TOTAL LEAKAGE (both wheels)
  Q_leak(ii) = Q_tip(ii) + Q_lat(ii) + Q_drain(ii) + Q_mesh(ii) + Q_rlf(ii) + Q_back(ii); %[mm3/s] !!!!!
end

%dteta = deg2rad(theta(2) - theta(1)); %[rad]
%Volume leakage in a complete revolution
% Vleak = sum((Q_leak./omega).*dteta); %[mm3/rev] for a single pitch angle
% Vleak = Vleak*Z; %[mm3/rev] a full rotation is composed by Z pitch angles
% %Volumetric efficiency
% nVol = 1 - Vleak/(Displ);

nVol = 1 - mean(Q_leak)/(Displ*omega/(2*pi)); % 1 - (Mean leakage and mean theorical flow ratio)!

end